:: post_install_configs.bat
::
:: Post installation activites to make a backup of the current
:: configuration files, copy the uninstall executable and data file
:: to the parent directory for generic execution
::
:: Any/all output is sent to z_post_install_configs_%4.log
::
:: %1 is the New Install,        I.E. "..\Moog_Config_001-00-00"
:: %2 is the backup src,         I.E. "..\data\configurations"
:: %3 is the backup dst prefix,  I.E. "..\data\backups\configurations_Moog"
:: %4 is the configuration,      I.E. "Moog", "GE", etc.
::
:: ====================================================================
@ECHO OFF

ECHO Finishing WinDrive %4 Configuration Module Installation, please wait...
ECHO.
SetLocal

if exist z_post_install_config_%4.log del z_post_install_configs_%4.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_post_install_configs_%4.log

echo Make a backup of the prior configuration data
:: Make a backup of the prior configuration data
:: --------------------------------------------------------------------
CALL Backup.bat %2 %3_%4 >> z_post_install_configs_%4.log


:: Copy up the uninstall executable and data file of the current version
:: for generic uninstall
:: --------------------------------------------------------------------
CALL COPY %1\unins000.* ..\scripts\uninstall_configs_%4.* >> z_post_install_configs_%4.log

:: Now create/copy the new data %1 to the common location of the
:: configurations files %2, uncoupling the GUI from knowing the specific
:: configuration installation
::
:: Switch "/E" Copy dirs and sub-dirs and empty files
:: Switch "/Q" Suppress display of filenames copied
:: Switch "/Y" Suppress Overwrite Prompts
:: --------------------------------------------------------------------
CALL XCOPY /E /Q /Y %1\data\configurations\*.* ..\data\configurations\*.* >> z_post_install_configs_%4.log
CALL XCOPY /E /Q /Y %1\data\units\*.*          ..\data\units\*.*          >> z_post_install_configs_%4.log


:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".

CALL ie4uinit.exe -ClearIconCache >> z_post_install_configs_%4.log

:END
ECHO Operation Complete
ECHO.
EndLocal
