:: post_uninstall_GUI.bat
::
:: A post uninstallation script to perform any cleanup.  The uninstall
:: is executed 1 directory above the install folder, not all of the files
:: are removed, this file does the cleanup.
::
:: Any/all output is sent to z_post_uninstall_GUI_%2.log
::
:: %1 is the tree to be removed, I.E. "..\GUI_R009-03-00"
:: %2 is the configuration,      I.E. "Moog", "GE", etc.
::
:: ====================================================================
@ECHO OFF
ECHO Finishing WinDrive GUI Module Uninstall for %2, please wait...
ECHO.
SetLocal

if exist z_post_uninstall_GUI_%2.log del z_post_uninstall_GUI_%2.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_post_uninstall_GUI_%2.log

:: Perform the cleanup, removing any remaining files
::
:: Switch "/S" remove the folder, subdirectories and files
:: Switch "/Q" execute silently, no prompting or output
:: --------------------------------------------------------------------
RMDIR %1 /S /Q >> z_post_uninstall_GUI_%2.log
ERASE /F /Q %1\..\scripts\uninstall_GUI_%2.* >> z_post_uninstall_GUI_%2.log

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".
CALL ie4uinit.exe -ClearIconCache >> z_post_uninstall_GUI_%2.log

:END
ECHO Operation Complete
ECHO.
EndLocal
