:: uninstall_All_Modules.bat
::
:: A very silent un-install that avoids prompting and output messages
:: minimizing User interaction and supporting unattended installs.
::
:: Uninstall Motors, Configurations and GUI without prompting
::
:: %1 is the configuration,      I.E. "Moog", "GE", etc.
::
:: Any/all output is sent to z_uninstall_All_Modules_%1.log
::
:: ====================================================================
@ECHO OFF
ECHO Uninstalling All WinDrive Modules: GUI, %1 Configurations, and Motors please wait...
ECHO.
SetLocal

if exist z_uninstall_All_Modules_%1.log del z_uninstall_All_Modules_%1.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_uninstall_All_Modules_%1.log

cd /D %SystemDrive%\Moog\WinDrive\scripts

:: The installers create the generic named uninstallers, abstracting the
:: GUI from the versions of the Motors and Configs.  The uninstall*.bat
:: files are created by the installers and thus will get deleted during
:: and uninstall.  This results in an expected error of "...batch file not found...".  
:: Therefore, STDERR "2" is redirected.
if exist uninstall_motors.exe call uninstall_motors.bat >> z_uninstall_All_Modules_%1.log 2>&1

if exist uninstall_configs_%1.exe call uninstall_configs.bat %1 >> z_uninstall_All_Modules_%1.log 2>&1

if exist uninstall_GUI_%1.exe    call uninstall_GUI.bat %1    >> z_uninstall_All_Modules_%1.log 2>&1

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".

CALL ie4uinit.exe -ClearIconCache >> z_uninstall_All_Modules_%1.log

:END
ECHO Operation Complete
ECHO.
EndLocal
