:: setup_motors_verysilent.bat
::
:: A very silent install that avoids prompting and output messages
:: minimizing User interaction and supporting unattended installs.
::
:: Any/all output is sent to z_setup_motors.log
::
:: Copy necessary files manually to %SystemDrive%\Moog\WinDrive
:: ====================================================================
@ECHO OFF
ECHO Installing WinDrive Motors Module, please wait...
ECHO.
SetLocal

if exist z_setup_motors.log del z_setup_motors.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_setup_motors.log

:: If the *.iss is used, those files will get deleted on an uninstall.
:: Therefore, they can not be used in the [UninstallRun] section since
:: that is launched, but the uninstall doesn't wait for completion;
:: and those files could be deleted.
::
:: Switch "/E" Copy dirs and sub-dirs and empty files
:: Switch "/Q" Suppress display of filenames copied
:: Switch "/Y" Suppress Overwrite Prompts

CALL XCOPY /E /Q /Y .\scripts\*.* %SystemDrive%\Moog\WinDrive\scripts\*.* >> z_setup_motors.log

:: Perform a Very Silent Install of the WinDrive Configurations.
:: ====================================================================
CALL .\modules\setup_motors.exe  /SP- /SUPPRESSMSGBOXES /VERYSILENT /LOG >> z_setup_motors.log

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".
CALL ie4uinit.exe -ClearIconCache >> z_setup_motors.log

:END
ECHO Operation Complete
ECHO.
EndLocal

