@ECHO OFF
:: Backup.bat
::
:: Make a backup copy of the Requested Files
::
:: Any/all output is sent to the NUL device.
::
:: %1 is the backup src,         I.E. ".\data\configurations"
:: %2 is the backup dst prefix,  I.E. ".\data\backups\configurations_Moog"
:: ====================================================================

:: Making a backup copy with a date and timestamp
:: --------------------------------------------------------------------
::
:: Builds a date-time string for the backup folder name.
:: An example is: 20130611-0235PM
FOR /f "tokens=2-4 delims=/ " %%a in ('date /t') do (set mydate=%%c%%a%%b)
FOR /f "tokens=1,2,3 delims=/:/ " %%a in ('time /t') do (set mytime=%%a%%b%%c)

:: Now create the backup
::
:: Switch "/E" Copy dirs and sub-dirs and empty files
:: Switch "/Q" Suppress display of filenames copied
:: Switch "/Y" Suppress Overwrite Prompts
:: --------------------------------------------------------------------
CALL XCOPY /E /Q /Y %1\*.* %2.backup.%mydate%-%mytime%\*.* > NUL

:END
