@echo off
::
:: Delete Backups made during installation of WinDrive Modules
::
:: Any/all output is sent to the NUL device.
::
:: %1 is the wild card filename(s) to be deleted, examples are:
::	"WinDrive.backup.*", "configurations_Moog.backup.*", "motors.backup.*"
:: ====================================================================

echo Procedure to delete unnecessary WinDrive backup files.
echo.
echo Frequent or repeated installations can cause backups to
echo accumulate, consuming excessive disk space.  This procedure
echo can be used to manange the backups which are needed.
echo.
:: If the Input File Name is blank, do not delete anything.
IF /I NOT [%1]==[] GOTO CHECK_FOR_FILES
echo *** Missing Input File Name Parameter
echo.
GOTO END

:CHECK_FOR_FILES
IF EXIST %1 GOTO CONTINUE
echo *** There are no backup files at present 
echo.
GOTO END

:CONTINUE
echo *** The files "%cd%\%1" will be deleted: ***
echo.
dir %1 /B
echo.

SET prog2110_resp=
SET /P prog2110_resp=[Enter 'Y' to Delete All, 'S' to Select Files, or any other key to exit] 
echo.
IF /I [%prog2110_resp%]==[S] GOTO SELECT
IF /I [%prog2110_resp%]==[Y] GOTO DELETE_ALL
echo *** No files chosen
echo.
GOTO END

:SELECT
:: Perform a recursive delete on all files and subdirectories for each
:: backup folder generated from the input file name parameter which
:: is typically a wildcard such as "WinDrive.backup.*".  The User will
:: be prompted for each top-level folder to be deleted.
for /d %%a in (%1) do rd /s "%%~a"
echo.
GOTO END

:DELETE_ALL
:: Confirm the Delete All Request
SET prog2110_resp=
SET /P prog2110_resp=[Confirm Deletion of All Backups by entering 'Y', or any other key to exit] 
echo.
IF /I [%prog2110_resp%]==[Y] GOTO CONFIRMED_DELETE_ALL
echo *** No files chosen
echo.
GOTO END

:CONFIRMED_DELETE_ALL
:: Perform a recursive delete in quiet mode on all files and subdirectories
:: for each backup folder generated from the input file name parameter which
:: is typically a wildcard such as "WinDrive.backup.*".
echo *** Deleting all backups, please wait...
for /d %%a in (%1) do rd /S /Q "%%~a"
echo.
GOTO END

:: Add other steps as necessary, delete the previous "GOTO END"


:END
PAUSE