:: post_install_GUI.bat
::
:: Post installation activites to make a backup of the current
:: installed files, copy the uninstall executable and data file
:: to the parent directory for generic execution
::
:: Any/all output is sent to z_post_install_GUI_%4.log
::
:: %1 is the New Install,        I.E. "..\GUI_R009-03-00"
:: %2 is the backup src,         I.E. "..\..\WinDrive"
:: %3 is the backup dst prefix,  I.E. "..\..\WinDrive"
:: %4 is the configuration,      I.E. "Moog", "GE", etc.
::
:: ====================================================================
@ECHO OFF
ECHO Finishing WinDrive GUI Installation for %4, please wait...
ECHO.
SetLocal

if exist z_post_install_GUI_%4.log del z_post_install_GUI_%4.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_post_install_GUI_%4.log

:: Make a backup of the prior configuration data
:: --------------------------------------------------------------------
CALL Backup.bat %2 %3 >> z_post_install_GUI_%4.log

:: Copy up the uninstall executable and data file of the current version
:: for generic uninstall
:: --------------------------------------------------------------------
CALL COPY %1\unins000.* ..\scripts\uninstall_GUI_%4.* >> z_post_install_GUI_%4.log 

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".

CALL ie4uinit.exe -ClearIconCache >> z_post_install_GUI_%4.log

:END
ECHO Operation Complete
ECHO.
EndLocal
