:: post_install_motors.bat
::
:: Post installation activites to make a backup of the current
:: motor files, copy the uninstall executable and data file
:: to the parent directory for generic execution.  Note this batch
:: file is executed by the installer; hence any files created will
:: be deleted in the uninstall process.
::
:: Any/all output is sent to z_post_install_motors.log
::
:: %1 is the New Install,        I.E. "..\Motors_001-00-00"
:: %2 is the backup src,         I.E. "..\data\motors"
:: %3 is the backup dst prefix,  I.E. "..\data\backups\motors"
:: ====================================================================
@ECHO OFF
ECHO Finishing WinDrive Motor Module Installation, please wait...
ECHO.
SetLocal

if exist z_post_install_motors.log del z_post_install_motors.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_post_install_motors.log

:: Make a backup of the prior configuration data
:: --------------------------------------------------------------------
CALL Backup.bat %2 %3 >> z_post_install_motors.log

:: Copy the un-install executable and data file of the current version
:: for generic uninstall.  
:: --------------------------------------------------------------------
CALL COPY %1\unins000.* ..\scripts\uninstall_motors.* >> z_post_install_motors.log

:: Now create/copy the new data to the common location of the
:: motors files, uncoupling the GUI from knowing the specific
:: motors installation
::
:: Switch "/E" Copy dirs and sub-dirs and empty files
:: Switch "/Q" Suppress display of filenames copied
:: Switch "/Y" Suppress Overwrite Prompts
:: --------------------------------------------------------------------
CALL XCOPY /E /Q /Y %1\data\motors\*.* ..\data\motors\*.* >> z_post_install_motors.log

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".

CALL ie4uinit.exe -ClearIconCache >> z_post_install_motors.log

:END
ECHO Operation Complete
ECHO.
EndLocal
