:: post_uninstall_motors.bat
::
:: A post un-installation script to perform any cleanup.  The uninstall
:: is executed 1 directory above the install folder, not all of the files
:: are removed, this file does the cleanup.
::
:: Any/all output is sent to z_post_uninstall_motors.log
::
:: %1 is the tree to be removed, I.E. "..\Motors_001-00-00"
:: ====================================================================
@ECHO OFF
ECHO Finishing WinDrive Motor Module Uninstall, please wait...
ECHO.
SetLocal

if exist z_post_uninstall_motors.log del z_post_uninstall_motors.log > NUL
echo Procedure executed on "%DATE% %TIME%" > z_post_uninstall_motors.log

:: Perform the cleanup, removing any remaining files
::
:: Switch "/S" remove the folder, subdirectories and files
:: Switch "/Q" execute silently, no prompting or output
:: --------------------------------------------------------------------
RMDIR %1 /S /Q >> z_post_uninstall_motors.log
ERASE /F /Q %1\..\scripts\uninstall_motors.* >> z_post_uninstall_motors.log

:: Experience with Windows 7 reveals updates to the Start Menu are inconsistent.
:: Clear the icon cache so that explorer.exe updates entires based on 
:: "%SystemDrive%\ProgramData\Microsoft\Windows\Start Menu\Programs".

CALL ie4uinit.exe -ClearIconCache >> z_post_uninstall_motors.log

:END
ECHO Operation Complete
ECHO.
EndLocal